﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.IO;
using System.Xml;

namespace Remoting
{
	[Serializable]
	public class RMessage
	{
		public static readonly string BEGIN = "<BEGIN<";

		public static readonly string END = ">END>";

		private static readonly XmlSerializer Serializer = new XmlSerializer(typeof(RMessage));

		public string Action { get; set; }

		public object[] Args { get; set; }

		public RMessage()
		{
		}

		public RMessage(string action, params object[] args)
			: this()
		{
			Action = action;
			Args = args;
		}

		public void Serialize(Stream stream)
		{
			using (NonClosingStream ncs = new NonClosingStream(stream))
			{
				using (StreamWriter sw = new StreamWriter(ncs))
				{
					sw.WriteLine(BEGIN);
					StringBuilder sb = new StringBuilder();
					using (XmlWriter writer = XmlWriter.Create(sb))
					{
						Serializer.Serialize(writer, this);
					}
					sw.WriteLine(Convert.ToBase64String(Encoding.UTF8.GetBytes(sb.ToString())));
					sw.WriteLine(END);
				}
			}
		}

		public static RMessage Deserialize(Stream stream)
		{
			using (NonClosingStream ncs = new NonClosingStream(stream))
			{
				using (StreamReader sw = new StreamReader(ncs))
				{
					while (sw.ReadLine() != BEGIN)
					{
						// skip
					}
					// got a begin
					string line;
					StringBuilder base64 = new StringBuilder();
					while ((line = sw.ReadLine()) != END)
					{
						// read lines until we are at end
						base64.AppendLine(line);
					}
					// now we are at end, deserialize it
					using (XmlReader reader = XmlReader.Create(new StringReader(Encoding.UTF8.GetString(Convert.FromBase64String(base64.ToString())))))
					{
						return (RMessage)Serializer.Deserialize(reader);
					}
				}
			}
		}

		public override string ToString()
		{
			return string.Format("{0} (... {1})", Action, Args.Length);
		}
	}
}
